/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.Event;

import com.hoshino.cti.library.modifier.CtiModifierHook;
import com.hoshino.cti.library.modifier.hooks.EffectApplicableModifierHook;
import com.hoshino.cti.library.modifier.hooks.LeftClickModifierHook;
import com.hoshino.cti.library.modifier.hooks.OnDeathModifierHook;
import com.hoshino.cti.library.modifier.hooks.OnHoldingPreventDeathHook;
import com.hoshino.cti.library.modifier.hooks.SlotStackModifierHook;
import com.hoshino.cti.util.EquipmentUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ItemStackedOnOtherEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

@Mod.EventBusSubscriber(modid="cti")
public class ToolEvents {
    @SubscribeEvent
    public static void onLeftClick(PlayerInteractEvent.LeftClickEmpty event) {
        ItemStack stack;
        Player player = event.getEntity();
        if (player != null && player.f_19853_.f_46443_ && (stack = player.m_21120_(player.m_7655_())).m_41720_() instanceof IModifiable) {
            EquipmentSlot slot = stack.getEquipmentSlot();
            LeftClickModifierHook.handleLeftClick(stack, player, slot);
        }
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        BlockPos pos = event.getPos();
        if (player != null) {
            BlockState state = player.f_19853_.m_8055_(pos);
            ItemStack stack = player.m_21120_(player.m_7655_());
            if (stack.m_41720_() instanceof IModifiable) {
                EquipmentSlot slot = stack.getEquipmentSlot();
                LeftClickModifierHook.handleLeftClickBlock(stack, player, slot, state, pos);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void EffectApply(MobEffectEvent.Applicable event) {
        if (event.getEntity() != null) {
            block0: for (EquipmentSlot slot : EquipmentUtil.ALL) {
                if (!(event.getEntity().m_6844_(slot).m_41720_() instanceof IModifiable)) continue;
                ToolStack tool = ToolStack.from((ItemStack)event.getEntity().m_6844_(slot));
                boolean notApplicable = event.getResult() == Event.Result.DENY;
                for (ModifierEntry entry : tool.getModifierList()) {
                    notApplicable = ((EffectApplicableModifierHook)entry.getHook(CtiModifierHook.EFFECT_APPLICABLE)).isNotApplicable((IToolStackView)tool, entry, slot, event.getEffectInstance(), notApplicable);
                    if (!notApplicable) continue;
                    event.setResult(Event.Result.DENY);
                    continue block0;
                }
            }
        }
    }

    public static boolean shouldPrevent(DamageSource source, boolean canIgnore) {
        if (source.m_19378_()) {
            return canIgnore;
        }
        return true;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void ToolHoldingDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        DamageSource source = event.getSource();
        EquipmentContext context = new EquipmentContext(livingEntity);
        if (context.hasModifiableArmor()) {
            for (EquipmentSlot slotType : EquipmentSlot.values()) {
                IToolStackView toolStack = context.getToolInSlot(slotType);
                if (toolStack == null || toolStack.isBroken()) continue;
                boolean canIgnore = OnHoldingPreventDeathHook.canIgnorePassInvul(CtiModifierHook.PREVENT_DEATH, context);
                float HealthRemain = OnHoldingPreventDeathHook.onHoldingPreventDeath(CtiModifierHook.PREVENT_DEATH, context, source, event.getEntity());
                if (ToolEvents.shouldPrevent(source, canIgnore) && HealthRemain > 0.0f) {
                    event.setCanceled(true);
                    event.getEntity().m_21153_(HealthRemain);
                    event.getEntity().m_213846_((Component)Component.m_237115_((String)"etshtinker.message.death_prevent").m_130940_(ChatFormatting.AQUA));
                    return;
                }
                if (!livingEntity.m_21224_()) continue;
                OnDeathModifierHook.handleDeath(CtiModifierHook.ON_DEATH, context, source, livingEntity);
            }
        }
    }

    @SubscribeEvent
    public static void onStackedItemOnOther(ItemStackedOnOtherEvent event) {
        if (SlotStackModifierHook.handleSlotStackOnOther(event.getCarriedItem(), event.getSlot(), event.getClickAction(), event.getPlayer())) {
            event.setCanceled(true);
            SlotStackModifierHook.handleSlotStackOnMe(event.getStackedOnItem(), event.getCarriedItem(), event.getSlot(), event.getClickAction(), event.getPlayer(), event.getCarriedSlotAccess());
        } else if (SlotStackModifierHook.handleSlotStackOnMe(event.getStackedOnItem(), event.getCarriedItem(), event.getSlot(), event.getClickAction(), event.getPlayer(), event.getCarriedSlotAccess())) {
            event.setCanceled(true);
        }
    }
}

